import csv
from typing import Iterator

from allennlp.data import Instance
from allennlp.data.fields import TextField

from config import Config
from tools.utils import create_dir_of_file
from .dataset_reader import DatasetReader


class MRDatasetReader(DatasetReader):
    def __init__(self, cf: Config, token_type=None):
        super(MRDatasetReader, self).__init__(cf, token_type, lazy=False)

    def _read(self, file_path: str) -> Iterator[Instance]:
        with open(file_path, "r") as f:
            csv_file = csv.reader(f)
            for row in csv_file:
                yield self.text_to_instance(row[0], row[1])

    def _write(self, file_path: str, data):
        create_dir_of_file(file_path)
        with open(file_path, 'w') as f:
            csv_file = csv.writer(f)
            for d in data:
                sentence = d['sentence']
                label = d['label']
                csv_file.writerow([sentence, label])

    def read_json(self, file_path):
        data = []
        with open(file_path, "r") as f:
            csv_file = csv.reader(f)
            for row in csv_file:
                data.append(self.text_to_json(row[0], row[1]))
        return data
